// List of valid email domains for validation
const validDomains = [
    "gmail.com",
    "yahoo.com",
    "hotmail.com",
    "outlook.com",
    "inbox.lv",
    "mail.lv"
];

const emailField = document.getElementById("email");
const emailError = document.getElementById("email-error");
const countryCodeField = document.getElementById("country-code");
const phoneNumberField = document.getElementById("phone-number");

// Email validation
emailField.addEventListener("blur", () => {
    const emailValue = emailField.value;
    const domain = emailValue.split("@")[1];

    if (domain && validDomains.includes(domain)) {
        emailError.textContent = "";
        emailField.style.borderColor = "#ddd";
    } else {
        emailError.textContent = "Lūdzu, ievadiet derīgu e-pasta adresi!";
        emailField.style.borderColor = "red";
    }
});

// Update phone number with country code
countryCodeField.addEventListener("change", () => {
    phoneNumberField.value = countryCodeField.value + " ";
});
